(function () {
	var tests = [];
	var deps = [];
	for (var file in window.__karma__.files) {
		if (window.__karma__.files.hasOwnProperty(file)) {

			if (/[Ss]pec\.js$/.test(file)) {
				tests.push(file);
			}
		}
	}
	deps = ['lodashDatestrMixin', 'UnderscoreRenderer'].concat(tests);

	require.config({
		baseUrl: '/base/veteran-appointment-requests/app/',

		paths: {
			// Libraries
            'backbone': '../libs/js/backbone-min',
            'backbone.radio': '../libs/js/backbone.radio',
            'datepicker': '../libs/js/datepicker/bootstrap-datepicker.min',
            'FormParams': '../libs/js/jquery.formparams',
            'Jasmine': '../test/libs/js/jasmine-1.3.1',
            'JasmineHtml': '../test/libs/js/jasmine-html-1.3.1',
            'JasmineJQuery': '../test/libs/js/jasmine-jquery',
            'jquery': '../libs/js/jquery-2.1.4.min',
            'jqm': '../libs/js/jquery.mobile-1.4.5.min',
            'jwt_decode': '../libs/js/jwt-decode',
            'marionette': '../libs/js/backbone.marionette.min',
            'moment': '../libs/js/moment-2.7.0',
            'momentTz': '../libs/js/moment-timezone-with-data.min',
            'underscore': '../libs/js/lodash.min',
            'lodashDatestrMixin': 'js/mixin/lodash-datestr-mixin',
            'jquery.mask': '../libs/js/jquery.mask',
            'jquery.validate': '../libs/js/jquery.validate',
            'jquery.validate.additional-methods': '../libs/js/jquery.validate.additional-methods',
            'Vent': 'js/vent',
            // 'App': 'app',
            'FontFaceObserver': '../libs/js/fontfaceobserver',
			//App: 'app',

            // paginator

            'backgrid': '../libs/js/paginator/backgrid',
            'backbone.paginator': '../libs/js/paginator/backbone.paginator',
            'backgrid-paginator': '../libs/js/paginator/extensions/backgrid-paginator',


            // Plugin for text resources, e.g.: templates
			text: '../libs/js/text',
			json: '../libs/js/json',

			// Tools
			loadingSpinner: 'modules/loading-spinner/loading-spinner',
			'jqm.config': 'js/config/jqm.config',
			'jquery.validate.config': 'js/config/jquery.validate.config',
			'jquery.mask.config': 'js/config/jquery.mask.config',
			LoginUtils: 'js/tools/LoginUtils',
			IOSOrientationChangeFix: 'js/tools/ios-orientationchange-fix.min',
			UnderscoreRenderer: 'js/tools/marionette.underscore-renderer',

			// Models
			// User: 'models/user',

			// Views
			HeaderView: 'modules/page/header/header-view',
			MainView: 'modules/page/main-view',

			//Routers
			AppRouter: 'js/router',
			appointmentsRouter: 'modules/appointments/appointments-router',

			// Error and Authentication Handlers
			connectionModule: 'modules/connection/connection-module',
			Global: '../test/spec_helpers/global',

			// mocks
	        resourceDirectoryJson: '../test/spec_helpers/resource-directory.json',
			App: "../test/spec_helpers/app",
			Layout: "../test/spec_helpers/layoutShell",
			User: "../test/spec_helpers/User",
			versionInfoJson: '../test/spec_helpers/version.json',
			featureFlagJson: '../test/spec_helpers/config.json',
			spec_helpers: '../test/spec_helpers',
			
			//Config
			//NOTE: Having inside spec_helpers works, but ../external-links triggers 404
			externalLinksJson: '../test/spec_helpers/external-links.json',
			notificationInfoJson: 'modules/notification-info/notification-info-popup-content.json'
		},
		waitSeconds: 200,
		shim: {
			'jquery': {
				exports: '$'
			},
			'FormParams': {
				deps: ['jquery']
			},
			'jqm.config': {
				deps: ['jquery']
			},
			'Global': {
				deps: ['moment', 'backbone', 'marionette']
			},
			'jqm': {
				deps: ['jqm.config']
			},
			'backbone': {
				deps: ['jquery', 'underscore'],
				exports: 'backbone'
			},
			'jquery.mask': {
				deps: ['jquery', 'jquery.mask.config']
			},
			'JasmineJQuery': {
				deps: ['jquery']
			},
			'Jasmine': {
				deps: ['JasmineJQuery'],
				exports: 'Jasmine'
			},
			'JasmineHtml': {
				deps: ['Jasmine'],
				exports: 'Jasmine'
			}
		},
		// ask Require.js to load these files (all our tests)
		deps: deps,

		// start test run, once Require.js is done
		callback: window.__karma__.start
	});


}());
